<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class RateLimitMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $key = sprintf("rate_limit:%s", $request->ip());
        $limit = 10; // batas jumlah permintaan
        $decayMinutes = 1; // waktu dalam menit

        if (Cache::has($key) && Cache::get($key) >= $limit) {
            return response()->json(['message' => 'Terlalu banyak permintaan. Silakan coba lagi nanti.'], 429);
        }

        Cache::increment($key);
        Cache::put($key, Cache::get($key), now()->addMinutes($decayMinutes));

        return $next($request);
    }
}